/**
 * @file    mg32_syscfg.h
 * @author  MegawinTech Application Team
 * @brief   This file contains all the functions prototypes for the SYSCFG firmware
 *          library.
 */

/*!< Define to prevent recursive inclusion ---------------------------------------------------------------------------*/
#ifndef __MG32_SYSCFG_H
#define __MG32_SYSCFG_H


/*!< Includes --------------------------------------------------------------------------------------------------------*/
#include "mg32f04p032_device.h"

/** @addtogroup MG32_StdPeriph_Driver
  * @{
  */

/** @defgroup SYSCFG
  * @{
  */

/** @defgroup SYSCFG_Exported_Types
  * @{
  */
/**
  * @brief  Output Maximum frequency selection
  */
typedef enum
{
    I2C_Port_OD = 0,                   /*!< open-drain */
    I2C_Port_PP = 1                    /*!< Push-pull */
} I2CPortMode_TypeDef;

/**
  * @}
  */

/** @defgroup SYSCFG_Exported_Constants
  * @{
  */

/**
  * @brief SYSCFG_EXTI_Port_Sources
  */

#define EXTI_PortSourceGPIOA       ((uint8_t)0x00)
#define EXTI_PortSourceGPIOB       ((uint8_t)0x01)

/**
* @brief SYSCFG_EXTI_Pin_sources 
*/ 
#define EXTI_PinSource0            ((uint8_t)0x00)
#define EXTI_PinSource1            ((uint8_t)0x01)
#define EXTI_PinSource2            ((uint8_t)0x02)
#define EXTI_PinSource3            ((uint8_t)0x03)
#define EXTI_PinSource4            ((uint8_t)0x04)
#define EXTI_PinSource5            ((uint8_t)0x05)
#define EXTI_PinSource6            ((uint8_t)0x06)
#define EXTI_PinSource7            ((uint8_t)0x07)
#define EXTI_PinSource8            ((uint8_t)0x08)
#define EXTI_PinSource9            ((uint8_t)0x09)
#define EXTI_PinSource10           ((uint8_t)0x0A)
#define EXTI_PinSource11           ((uint8_t)0x0B)
#define EXTI_PinSource12           ((uint8_t)0x0C)
#define EXTI_PinSource13           ((uint8_t)0x0D)
#define EXTI_PinSource14           ((uint8_t)0x0E)
#define EXTI_PinSource15           ((uint8_t)0x0F)

/**
* @brief SYSCFG_Memory_Remap_Config 
*/ 
#define SYSCFG_MemoryRemap_Flash                ((uint8_t)0x00)
#define SYSCFG_MemoryRemap_SystemMemory         ((uint8_t)0x01)
#define SYSCFG_MemoryRemap_SRAM                 ((uint8_t)0x03)

/**
  * @brief DMA_Channel_Remap
  */      
#define SYSCFG_ADC1_DMA_RMP_CH1        ((0x00 << 5U) | SYSCFG_CFGR_ADC1_DMA_RMP_Pos) 
#define SYSCFG_ADC1_DMA_RMP_CH2        ((0x01 << 5U) | SYSCFG_CFGR_ADC1_DMA_RMP_Pos)       
#define SYSCFG_USART1_TX_DMA_RMP_CH1   ((0x00 << 5U) | SYSCFG_CFGR_USART1_TX_DMA_RMP_Pos) 
#define SYSCFG_USART1_TX_DMA_RMP_CH2   ((0x01 << 5U) | SYSCFG_CFGR_USART1_TX_DMA_RMP_Pos)
#define SYSCFG_USART1_RX_DMA_RMP_CH2   ((0x00 << 5U) | SYSCFG_CFGR_USART1_RX_DMA_RMP_Pos)                                          
#define SYSCFG_USART1_RX_DMA_RMP_CH1   ((0x01 << 5U) | SYSCFG_CFGR_USART1_RX_DMA_RMP_Pos)  

/**
  * @}
  */

/** @defgroup SYSCFG_Exported_Functions
  * @{
  */

void SYSCFG_DeInit(void);
void SYSCFG_MemoryRemapConfig(uint32_t SYSCFG_MemoryRemap);
void SYSCFG_EXTILineConfig(uint8_t port_source_gpio, uint8_t pin_source);
void SYSCFG_DMARemapConfig(uint8_t perip_dma);

#endif

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
